{\rtf1\ansi\ansicpg1252\deff0\deftab720{\fonttbl{\f0\fswiss MS Sans Serif;}{\f1\froman\fcharset2 Symbol;}{\f2\fmodern Courier New;}{\f3\froman Times New Roman;}{\f4\fswiss Arial;}}
{\colortbl\red0\green0\blue0;}
\deflang1033\horzdoc{\*\fchars }{\*\lchars }\pard\plain\f2\fs20 
\par --
\par -- Specifying the storage clause for a CREATE TABLE statement:
\par --
\par 
\par CREATE TABLE DEPT
\par  (DEPTNO    NUMBER(2)    CONSTRAINT PK_DEPT PRIMARY KEY,
\par   DNAME     VARCHAR2(14),
\par   LOC       VARCHAR2(13) 
\par )
\par PCTFREE 10
\par PCTUSED 40
\par STORAGE( 
\par   INITIAL 100K 
\par   NEXT 200K 
\par   MINEXTENTS 1
\par   MAXEXTENTS UNLIMITED
\par   PCTINCREASE 50)
\par ;
\par 
\par 
\par --
\par -- Creating, adding to and altering the characteristics of a tablespace
\par --
\par 
\par CREATE TABLESPACE TS_DATA
\par DATAFILE 'd:\\oracle\\data\\data_ts01.dbf' size 20M,
\par          'd:\\oracle\\data\\data_ts02.dbf' size 10M
\par DEFAULT STORAGE ( INITIAL 200K NEXT 100K PCTINCREASE 0)
\par ;
\par 
\par CREATE TABLESPACE NEW_TS DATAFILE 'd:\\oracle\\data\\new_ts01.dbf' size 200M
\par ;
\par 
\par ALTER TABLESPACE TS_DATA ADD DATAFILE 'd:\\oracle\\data\\data_ts03.dbf size 100M
\par ;
\par 
\par ALTER DATABASE DATAFILE 'd:\\oracle\\data\\data_ts02.dbf' RESIZE 80M
\par ;
\par 
\par CREATE TEMPORARY TABLESPACE TS_TEMPORARY TEMPFILE 'ts_temp_1.tdf'
\par EXTENT MANAGEMENT LOCAL UNIFORM SIZE 8M
\par ;
\par 
\par ALTER TABLESPACE TS_STATIC_DATA READ ONLY
\par ;
\par 
\par --
\par -- Transportable Tablespaces
\par --
\par 
\par execute DBMS_TTS.TRANSPORT_SET_CHECK('TS_DATA,TS_INDEX', TRUE);
\par 
\par --
\par -- EXP and IMP command line examples of how to move transportable tablespaces
\par --
\par 
\par EXP TRANSPORT_TABLESPACE=y 
\par     TABLESPACES=TS_DATA, TS_INDEX 
\par     TRIGGERS=y CONSTRAINTS=y GRANTS=y FILE=transport_data.dmp
\par 
\par IMP TRANSPORT_TABLESPACE=y 
\par       DATAFILES='d:\\oracle\\data\\data_ts01.dbf',
\par                 'd:\\oracle\\data\\data_ts02.dbf',
\par                 'e:\\oracle\\data\\index_ts01.dbf'
\par       TABLESPACES=DATA_TS,INDEX_TS
\par       FROMUSER=merak,joeuser TOUSER=merak2000,newuser 
\par       FILE=transport_data.dmp
\par 
\par 
\par --
\par -- Creating an index organized table
\par --
\par 
\par CREATE TABLE index_org_example
\par   ( archive_id          NUMERIC(10,0),
\par     document_id         NUMERIC(10,0),
\par     version_number      INTEGER,
\par     document_data       VARCHAR2(2000),
\par    CONSTRAINT pk_org_example PRIMARY KEY (archive_id, document_id) 
\par   )
\par ORGANIZATION INDEX TABLESPACE index_org_ts
\par INCLUDING version_number
\par OVERFLOW TABLESPACE index_org_overflow_ts;
\par 
\par 
\par --
\par -- How to specify the storage of LOBs in a separate tablespace with its
\par -- own storage characteristics
\par --
\par 
\par CREATE TABLE lob_example
\par   ( archive_id          NUMERIC(10,0),
\par     document_id         NUMERIC(10,0),
\par     version_number      INTEGER,
\par     document_data       BLOB,
\par    CONSTRAINT pk_org_example PRIMARY KEY (archive_id, document_id) 
\par   )
\par TABLESPACE data_ts
\par LOB(DOCUMENT_DATA) STORE AS DOCUMENT_LOB
\par  ( TABLESPACE lob_ts
\par    PCTVERSION 5
\par    NOCACHE
\par    LOGGING
\par    STORAGE (INITIAL 10M NEXT 20M MAXEXTENTS 5) 
\par   )
\par ; 
\par \plain\f4\fs20 
\par }
 